/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package Main;

/**
 * Štruktúra na zapamätanie si jedného policka v tabulke vrcholov (redukovaneho) grafu variantov
 * Pre kazdu poziciu v referencnej sekvencii genu mame jedno policko
 * Policko sluzi na zapamatanie poctu adeninovych, cytozinovych, guaninovych, tyminovych, neznamych ci celkoveho poctu alternatív
 * Tato struktura zjednodusi filtrovanie
 * @author mato
 */

public class Policko {
    int A, C, G, T, N, celkom;
    
    /**
     * Konštruktor triedy Policko
     */
    public Policko(){
        this.A = 0;
        this.C = 0;
        this.G = 0;
        this.T = 0;
        this.N = 0;
        this.celkom = 0;
    }
    
    /**
     * scita alternativy, ktore su ine ako alternativa zmena
     * @param zmena aleternativa
     * @return pocet alternativ, ktore su ine ako je alternativa zmena
     */
    
    public int scitaj (String zmena){
        int result = 0;
        if (!(zmena.equals("A"))){
            result = result + this.A;
        }
        
        if (!(zmena.equals("C"))){
            result = result + this.C;
        }
        
        if (!(zmena.equals("G"))){
            result = result + this.G;
        }
        
        if (!(zmena.equals("T"))){
            result = result + this.T;
        }
        
        if (!(zmena.equals("N"))){
            result = result + this.N;
        }
        return result;
    }
    
    /**
     * pripocita novu alternativu zo vstupu k aktualnemu poctu alternativ
     * @param zmena aleternativa
     */
    public void zmen(String zmena){
        switch (zmena.charAt(0)){
            case 'A':   this.A++;
                        break;
            case 'C':   this.C++;
                        break;
            case 'G':   this.G++;
                        break;
            case 'T':   this.T++;
                        break;
            case 'N':   this.N++;
                        break;
            default:    this.N++;
                        break;
        }
    }
    
    /**
     * zisti pocet vyskytov alternativy zo vstupu
     * @param zmena aleternativa
     * @return pocet alternativ
     */
    public int pocet(String zmena){
        int result = 0;
        if (zmena.length()>0){
            switch (zmena.charAt(0)){
                case 'A':   result = this.A;
                            break;
                case 'C':   result = this.C;
                            break;
                case 'G':   result = this.G;
                            break;
                case 'T':   result = this.T;
                            break;
                case 'N':   result = this.N;
                            break;
                default:    result = this.N;
                            break;
            }
        }
        return result;
    }
        
    /**
     * scita alternativy
     * aktualizuje premennu celkom
     */
    public void celkom() {
        int c = pocet("A") + scitaj("A");
        this.celkom = c;
    }
    
    /**
     * zistuje ci je aj ina alternativa okrem tej na vstupe
     * @param zmena vstupna alternativa
     * @param minVahaVrchola  minimalna vaha ktoru musi splanat korektna alternativa
     * @return true ak existuje okrem vstupnej alternativy aj ina alternativa v danom stlpci inak vrati false
     */
    public boolean varianta(String zmena, double minVahaVrchola) {
        if (zmena.equals("A") || zmena.equals("C") || zmena.equals("G") || zmena.equals("T") || zmena.equals("N")) {                        
            double pomer = (double) pocet("A") / (double) this.celkom;
            if (((pomer) > minVahaVrchola) &&(!zmena.equals("A"))) {
                return true;
            }
            pomer = (double) pocet("C") / (double) this.celkom;
            if (((pomer) > minVahaVrchola) &&(!zmena.equals("C"))) {
                return true;
            }
            pomer = (double) pocet("G") / (double) this.celkom;
            if (((pomer) > minVahaVrchola) &&(!zmena.equals("G"))) {
                return true;
            }
            pomer = (double) pocet("T") / (double) this.celkom;
            if (((pomer) > minVahaVrchola) &&(!zmena.equals("T"))) {
                return true;
            }
            pomer = (double) pocet("N") / (double) this.celkom;
            if (((pomer) > minVahaVrchola) &&(!zmena.equals("N"))) {
                return true;
            }
        }
        return false;
    }
    
}